/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.red;

import com.megacrit.cardcrawl.actions.common.DrawCardAction;
import com.megacrit.cardcrawl.actions.common.GainEnergyAction;
import com.megacrit.cardcrawl.actions.common.LoseHPAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Offering
extends AbstractCard {
    public static final String ID = "Offering";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Offering");
    public static final String NAME = Offering.cardStrings.NAME;
    public static final String DESCRIPTION = Offering.cardStrings.DESCRIPTION;
    private static final int COST = 0;
    private static final int HP_LOSS = 4;
    private static final int DRAW_AMT = 3;
    private static final int ENERGY_AMT = 2;
    private static final int POOL = 1;

    public Offering() {
        super(ID, NAME, "red/skill/offering", "red/skill/offering", 0, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.RED, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.SELF, 1);
        this.exhaust = true;
        this.magicNumber = this.baseMagicNumber = 3;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new LoseHPAction(p, p, 4));
        AbstractDungeon.actionManager.addToBottom(new DrawCardAction(p, this.magicNumber));
        AbstractDungeon.actionManager.addToBottom(new GainEnergyAction(2));
    }

    @Override
    public AbstractCard makeCopy() {
        return new Offering();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeMagicNumber(2);
        }
    }
}

